# Efficient Federated Domain Translation



## Installation

Our models are based on PyTorch.


## Introduction 

The ```/data``` folder contains indices of MNIST to generate subset which is from the public repository https://github.com/atuannguyen/DIRT for paper https://proceedings.neurips.cc/paper/2021/hash/2a2717956118b4d223ceca17ce3865e2-Abstract.html. It also contains indices for FashionMNIST. **Please also download the datasets here**. 

The ```/iaf``` folder contains the implementation of FedINB and FedINB with VW histograms. The code is based on the public repository https://github.com/inouye-lab/Iterative-Alignment-Flows for paper https://proceedings.mlr.press/v151/zhou22b/zhou22b.pdf. But we provide the PyTorch version (their original code is implemented based on Scikit-learn and PyTorch which does not support running on GPU.)

The ```/rmnist```  and ```/rfmnist``` folder contains codes for running experiments of federated domain translation.

The ```/rmnist/autoencoders``` and ```/rfmnist/autoencoders``` folder contains codes for training autoencoders and checkpoints we use.

The ```/rmnistdg``` and ```/rfmnistdg``` folder contains codes for running experiments of federated domain generalization.

The ```/baselines``` folder contains all codes for baseline experiments and its own README.


## Implementation
First, data_dir should always be /data. In the current implementation, the directory of loading data and indices(see below) need to in the same directory.
Besides, for anonymization, we remove the directory of ```sys.path.append('')```. Please add as needed.

### Federated domain translation
There are 6 scripts here for 6 FedINB models. We give a few examples of how to train different INB model.

INB (L10-K30-J100):

```python train_inb_cuda.py --mnist_subset 'full' --nlayers 10 --K 30 --max_swd_iters 100 --data_dir <> --save_dir <>``` 

HistINB (L10-K30-J100-V500):

```python train_inb_hist.py --mnist_subset 'full' --nlayers 10 --K 30 --max_swd_iters 100 --hist_bins 500 --quantile --data_dir <> --save_dir <>``` 

AEINB:

```tpython train_aeinb_cuda.py --mnist_subset 'full' --nlayers 10 --K 30 --max_swd_iters 100 --data_dir <> --save_dir <>``` 

HistAEINB:

```python train_aeinb_hist.py --mnist_subset 'full' --nlayers 10 --K 30 --max_swd_iters 100 --hist_bins 500 --quantile --data_dir <> --save_dir <>``` 

IndAEINB:

```python train_indaeinb_cuda.py --mnist_subset 'full' --nlayers 10 --K 30 --max_swd_iters 100 --data_dir <> --save_dir <>``` 

HistIndAEINB:

```python train_aeinb_hist.py --mnist_subset 'full' --nlayers 10 --K 30 --max_swd_iters 100 --hist_bins 500 --quantile --data_dir <> --save_dir <>``` 

### Federated domain generalization

To run FedDRIT:

```python fedtrain.py --tn 'indaeinb' --model-dir <root dir of saved inb checkpoint> --trans <saved inb checkpoint> --ae_dir <saved autoencoders> --data_dir <> --reg <regularization weight> --target_domain <>```

```--tn``` should be assigned to 'inb' or 'aeinb' or 'indaeinb'.

```--model-dir``` and ```--trans``` Model trained using code from federated domain translation experiment. Please change this argument ``` --mnist_subset '0' ``` when training corresponding translation model since we use less data in this case.

```--ae_dir``` We use the same autoencoders.
